#ifndef __CRangeSlider__
#define __CRangeSlider__

#include "CControl.hpp"
#include "CRolloverButton.hpp"
#include <MathTools/CBounds.hpp>

//	===========================================================================

using Exponent::GUI::Controls::CControl;
using Exponent::GUI::Controls::CRolloverButton;
using Exponent::MathTools::CBounds;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CRangeSlider CRangeSlider.hpp
			 * @brief A slider that allows you to change the top and bottom value as well as move the entire slider
			 *
			 * @date 17/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 * @version	1.0.1 Added Jump to max
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CRangeSlider.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CRangeSlider : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param listener The action listener
				 */
				CRangeSlider(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CRangeSlider();

//	===========================================================================

				/**
				 * Set the minimum value
				 * @param minValue The minimum value
				 */
				virtual void setMinimumValue(const double minValue);

				/**
				 * Set the maximum value
				 * @param maxValue The maximum value
				 */
				virtual void setMaximumValue(const double maxValue);

				/**
				 * Get the minimum value
				 * @retval double The minimum value of the slider
				 */
				virtual double getMinimumValue() const { return m_minValue; }

				/**
				 * Get the maximum value
				 * @retval double The maximum value of the slider
				 */
				virtual double getMaximumValue() const { return m_maxValue; }

//	===========================================================================

				/**
				 * Lock the positions
				 * @param lockMin If true min is locked to minValue
				 * @param lockMax If true max is locked to maxValue
				 * @param minValue If lockMin is true the min is locked to this value
				 * @param maxValue If lockMax is true the max is locked to this value
				 * @param jumpToMax If true the max will jump to this position, generally for use if min is locked in place
				 */
				virtual void lockPositions(const bool lockMin, const bool lockMax, const double minValue, const double maxValue, const bool jumpToMax = true);

				/**
				 * Set the colours
				 * @param frameColour The colour of the frame
				 * @param backgroundColour The background colour of the control
				 * @param handleColour The colour of the area that can be grabbed by the user
				 * @param handleOverColour The colour of the area that can be grabbed by the user when mouse is over
				 * @param handleDownColour The colour of the area that can be grabbed by the user when mouse is grabbing it
				 */
				virtual void setColours(CAlphaColour frameColour, CAlphaColour backgroundColour, CAlphaColour handleColour, CAlphaColour handleOverColour, CAlphaColour handleDownColour);

//	===========================================================================

				/**
				 * Handle left button being clicked
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonDown(CMouseEvent &event);

				/**
				 * Handle left button being released
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonUp(CMouseEvent &event);

				/**
				 * Handle the scroll wheel
				 * @param event The event to handle
				 */
				virtual void handleMouseScroll(CMouseEvent &event);

				/**
				 * Handle the mouse movement
				 * @param event The event to handle
				 */
				virtual void handleMouseMovement(CMouseEvent &event);

				/**
				 * Handle the mouse leaving the window area
				 * @param event The event to handle
				 */
				virtual void handleMouseLeavingArea(CMouseEvent &event);

//	===========================================================================

				/**
				 * Draw the controls
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

//	===========================================================================

			protected:

//	===========================================================================

				/**
				 * @enum EDragId
				 * @brief What is being draggged?
				 */
				enum EDragId
				{
					e_notDragging = 0,			/**< Nothing being dragged */
					e_draggingTop,				/**< Top being dragged */
					e_draggingHandle,			/**< Main bit being dragged */
					e_draggingBottom			/**< Bottom being dragged */
				};

//	===========================================================================

				/**
				 * Check if the area is rolled over and lock if necessary
				 * @param point The point to check
				 */
				virtual void checkAndLock(const CPoint &point);

				/**
				 * Handle movement
				 * @param event The event to handle
				 */
				void handleMovement(CMouseEvent &event);

				/**
				 * Handle movement in the top of the bar
				 * @param event The event to handle
				 */
				bool handleTopMovement(CMouseEvent &event);

				/**
				 * Handle movement in the bottom of the bar
				 * @param event The event to handle
				 */
				bool handleBottomMovement(CMouseEvent &event);

				/**
				 * Handle movement in the handle
				 * @param event The event to handle
				 */
				bool handleBarMovement(CMouseEvent &event);

//	===========================================================================

				CRect m_sliderArea;							/**< The area of the slider */
				CPoint m_grabOffset;						/**< What is the offset to where they grabbed? */
				CAlphaColour m_handleColour;				/**< Colour of the slider */
				CAlphaColour m_handleOverColour;			/**< Colour of the slider when mouse is over */
				CAlphaColour m_handleDownColour;			/**< Colour of the slider when mouse is down */

				CRolloverButton::ERolloverState m_state;	/**< Current state of slider (0 = off : 1 = over : 2 = on) */
				bool m_isVertical;							/**< Is the slider vertical? */
				EDragId m_dragId;							/**< Drag id */

				double m_minValue;							/**< The minimum values */
				double m_maxValue;							/**< The max value */

				bool m_lockMax;								/**< Lock the max? */
				bool m_lockMin;								/**< Lock the min? */
				bool m_jumpToMax;							/**< Should mouse down jump to the max value? -> implies lock min, moveable max */
			};
		}
	}
}
#endif	// End of CRangeSlider.hpp